/**
 * \file: util_lib_i.h
 *
 * \version: $Id: util_lib_i.h,v 1.11 2011/09/30 10:58:34 smaleyka Exp $
 *
 * This header file declares the basic types that are to be used for
 * programming on the ADIT platform.

 * \component: global definition file
 *
 * \author: T. Polle <tpolle(o)de.adit-jv.com>
 *
 * \copyright: (c) 2003 - 2008 ADIT Corporation
 *
 */
#ifndef __UTIL_LIB_I_H_
#define __UTIL_LIB_I_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "adit_trace.h"
#include "trace_interface.h"
#define  TR_CL     (TR_COMP_DRV_FM_DAB + 20)

IMPORT U32 UTIL_TraceOut(U32 uwLen, U16 trClass, TR_tenTraceLevel trLevel,
                          const U8* p_ubTrData);
IMPORT U32 UTIL_TraceBinOutput(U32 uwCompId, U32 uwSockId, U32 uwBufferLen,
                                U8* p_ubDataBuffer);
IMPORT BOOL UTIL_IsClassSelected(U16 enClass,
                                   TR_tenTraceLevel enLevel);
IMPORT BOOL UTIL_RegisterChannel(TR_tenTraceChan chan_id,
                                   const TRACE_CALLBACK p_Func);
IMPORT BOOL UTIL_UnregisterChannel(TR_tenTraceChan chan_id,
                                     const TRACE_CALLBACK p_Func);

#ifdef __cplusplus
};
#endif

#endif /* __UTIL_LIB_I_H_ */
